c This program solves the time dependent equations for
c  the simple model of exponential decay. There are 2N-1 "continuum"
c  states with equal coupling to the one state that can decay
c
c This program uses the leapfrog algorithm
c psi(t+dt) = psi(t-dt) - 2 i H(t) psi(t)
c
      program exp_decay_model
      parameter (nabv = 2000)
      implicit real*8 (a-h,o-z)
      complex *16 ceve(0:2*nabv-1), codd(0:2*nabv-1), icom
c define the complex number i
      icom = dcmplx(0.d0,1.d0)
c define pi
      pi = 2.d0*dasin(1.d0)
c the output will be in whatever is defined as file
      open(unit=20,file='exp_decay_1E9_2E7_2000.txt')
      open(unit=21,file='exp_edist_1E9_2E7_2000.txt')
c the coupling will be put in as a decay rate and Delta_omega
c gam = Gamma = the decay rate of the continuum limit
      gam = 1.d9
c delw = Delta_omega = Delta_E/hbar
      delw = gam*0.02
c now define the coupling term
      coe = sqrt(gam/2.0/pi)
c set the state energy E_0 = hbar omeg0
      omeg0 = 0.d0
c set the time step (you should check convergence with respect to dt)
      dt = 0.025/(nabv*delw)
c the combination coe*sqrt(delw)*dt occurs alot so define it to be parm
      parm = coe*sqrt(delw)*dt
c define the final time (tfin)
      tfin = 15.d0/gam
c define the number of steps in the numerical integration
      numtim = nint((tfin/dt))

c initialize the ceve=c(0) and codd(dt) by using the 2nd order Runge-Kutta alg.
c initialize the coefficients at t = dt/2
      ceve(0) = dcmplx(1.d0,0.d0)
      codd(0) = ceve(0)
       do 1 j = 1, 2*nabv-1
       ceve(j) = -icom*parm*0.5
       codd(j) = dcmplx(0.d0,0.d0)
 1     continue
      ceve(0) = ceve(0) - icom*0.5*omeg0*ceve(0)
c at this point ceve = c(dt/2) and codd = c(0)
      codd(0) = codd(0) - icom*dt*omeg0*ceve(0)
       do 2 j = 1, 2*nabv-1
       codd(0) = codd(0) - icom*parm*ceve(j)
       codd(j) = codd(j) - icom*parm*ceve(0) - 
     1                     icom*(j-nabv)*delw*dt*ceve(j)
       ceve(j) = dcmplx(0.0d0,0.d0)
 2     continue
      ceve(0) = dcmplx(1.0d0,0.0d0)
c now the ceve = c(0) and codd = c(dt)

c nmod is roughly how many steps to skip so the number of output points
c    are the denominator
      nmod = numtim/2000
      
c the 10 loop is the time steps
c  because of how the leapfrog algorithm works, the times are stepped in 2's
      do 10 itim = 2, numtim, 2
c define the time for step j
      tim = dfloat(itim-1)*dt
c step the psi(t)
      ceve(0) = ceve(0) - icom*(2*dt*omeg0)*codd(0)
       do 11 j = 1, 2*nabv-1
       ceve(0) = ceve(0) - icom*(2*parm)*codd(j)
       ceve(j) = ceve(j) - icom*(2*parm)*codd(0) - 
     1                     icom*(2*(j-nabv)*delw*dt)*codd(j)
 11    continue

      tim = dfloat(itim)*dt
c step the psi(t+dt)
      codd(0) = codd(0) - icom*(2*dt*omeg0)*ceve(0)
       do 12 j = 1, 2*nabv-1
       codd(0) = codd(0) - icom*(2*parm)*ceve(j)
       codd(j) = codd(j) - icom*(2*parm)*ceve(0) - 
     1                     icom*(2*(j-nabv)*delw*dt)*ceve(j)
 12    continue

c every nmod steps output the populations
      if(mod(itim,nmod) .le. 1) then
c test the normalization
      xno = 0.d0
       do 20 j = 1, 2*nabv-1
       xno = xno + abs(ceve(j))**2
 20    continue
c write the time in nanosecs, P_1, and normalization to the screen
      write(6,900)tim*1.e9,abs(ceve(0))**2,xno,xno+abs(ceve(0))**2
c write the timein microsecs, P_1, P_2, P_1+P_2 to the output file
      write(20,900)tim*1.e9,abs(ceve(0))**2,xno,xno+abs(ceve(0))**2
      end if
 10   continue
c end of time loop

c output the distribution of final states
      do 21 j = 1, 2*nabv-1
      w = (j-nabv)*delw
      write(21,900)w,abs(ceve(j))**2,
     1   (gam/2.0/pi*delw)/(0.25*gam*gam+(w-omeg0)**2)
 21   continue
c define the format of output
 900  format(8(1pe15.7))
      stop 'end of program'
      end
